from tdd_katas.text_utils import slugify

def test_slugify_basic():
    assert slugify("Hello World!") == "hello-world"

def test_slugify_whitespace_and_underscores():
    assert slugify("  A__B   C  ") == "a-b-c"

def test_slugify_non_alnum_removed():
    assert slugify("@Python_3.10 > 3.9?") == "python-3-10-3-9"

def test_slugify_collapse_and_trim_hyphens():
    assert slugify("--A---B--") == "a-b"
