import pytest
from tdd_katas.math_utils import is_prime

@pytest.mark.parametrize("n", [2, 3, 5, 7, 11, 13, 17, 19])
def test_is_prime_true(n):
    assert is_prime(n) is True

@pytest.mark.parametrize("n", [0, 1, -1, -2, 4, 6, 8, 9, 12, 15, 21, 100])
def test_is_prime_false(n):
    assert is_prime(n) is False

def test_is_prime_large():
    # 104729 is the 10000th prime
    assert is_prime(104729) is True
