from tdd_katas.cart import total

def test_total_simple_no_discounts():
    items = [{"name": "pen", "price": 1.5, "qty": 2}, {"name": "notebook", "price": 3.0, "qty": 1}]
    assert total(items) == 6.0  # 1.5*2 + 3.0*1

def test_total_bogof():
    items = [{"name": "pen", "price": 1.5, "qty": 3}]
    discounts = {"bogof": ["pen"]}
    # qty=3 with BOGOF → charged for 2 units
    assert total(items, discounts) == 3.0

def test_total_percent_discount():
    items = [{"name": "notebook", "price": 10.0, "qty": 2}]  # 20.0
    discounts = {"percent": 10}  # 10% off
    assert total(items, discounts) == 18.0

def test_total_bogof_and_percent():
    items = [{"name": "pen", "price": 1.5, "qty": 5}, {"name": "notebook", "price": 10.0, "qty": 1}]  # pen subtotal: charge 3 units → 4.5; notebook: 10.0; subtotal=14.5
    discounts = {"bogof": ["pen"], "percent": 10}
    assert total(items, discounts) == 13.05  # 10% off 14.5 → 13.05 rounded
