# TDD Mini Exercise (Python + pytest)

This small project gives you three tiny katas to practice **Test‑Driven Development** (Red → Green → Refactor).
The tests are written **first** and currently **fail**. Your job is to implement the functions until all tests pass.

## Setup
```bash
cd tdd-mini-exercise-python
python -m venv .venv
source .venv/bin/activate  # Windows: .venv\Scripts\activate
pip install -U pip pytest
```

## Run tests
```bash
pytest
```

You should see **failing tests** initially (that's the **Red** stage). Implement the functions in `src/tdd_katas/*.py` to make them pass (**Green**), then improve the code (**Refactor**) while keeping tests passing.

---

## Katas

### 1) `is_prime(n)` — basic number theory
**File:** `src/tdd_katas/math_utils.py`

**Behavior:**
- Return `True` for prime numbers (2, 3, 5, 7, 11, ...).
- Return `False` for non-primes and edge cases (0, 1, negatives, composites).
- Must be efficient enough for `n` up to, say, 10^6 (simple sqrt check is fine).

### 2) `slugify(text)` — string normalization for URLs
**File:** `src/tdd_katas/text_utils.py`

**Behavior:**
- Lowercase.
- Replace spaces and underscores with hyphens.
- Remove non-alphanumeric characters (keep ASCII letters, digits, and hyphens).
- Collapse repeated hyphens.
- Trim leading/trailing hyphens.

Examples:
- `slugify("Hello World!")` → `"hello-world"`
- `slugify(" A__B  C ")` → `"a-b-c"`

### 3) `total(items, discounts=None)` — tiny cart calculator
**File:** `src/tdd_katas/cart.py`

**Inputs:**
- `items`: list of dicts with keys `name` (str), `price` (float), `qty` (int ≥ 0)
- `discounts` (optional dict):
  - `"percent"`: e.g., `10` means 10% off the **subtotal**
  - `"bogof"`: list of item names under **buy-one-get-one-free** (every second unit is free)

**Behavior:**
- Subtotal = sum of `price * qty` (after considering BOGOF free units per applicable item).
- Apply percent discount to the subtotal if provided.
- Return a **rounded** total to 2 decimals.

Example:
- Items: `[{"name": "pen", "price": 1.50, "qty": 3}]`, BOGOF on `"pen"` → charge for 2 units (one free) → subtotal 3.00.

---

## Suggested Git Workflow (optional)
```bash
git init
git checkout -b feat/tdd-katas
pytest            # Red
# Implement is_prime
pytest            # Green (for that test file)
# Refactor if needed
git add -A && git commit -m "Implement is_prime"
# Repeat for slugify and cart total
```

When all tests pass, open a PR if you're using GitHub.

Good luck & have fun TDD-ing!
